
-- ================================
-- BASE DE DATOS DATA & BI ARG (2025)
-- Tablas: clientes, stock, ventas
-- Carga vía LOAD DATA INFILE
-- ================================

DROP TABLE IF EXISTS ventas;
DROP TABLE IF EXISTS stock;
DROP TABLE IF EXISTS clientes;

-- =========================
-- TABLA CLIENTES
-- =========================
CREATE TABLE clientes (
    cliente_id INT PRIMARY KEY,
    genero ENUM('M','F','Otro'),
    edad INT,
    provincia VARCHAR(50),
    fecha_alta DATE
);

-- =========================
-- TABLA STOCK
-- =========================
CREATE TABLE stock (
    producto_id INT,
    sucursal VARCHAR(50),
    stock_actual INT,
    stock_minimo INT,
    PRIMARY KEY (producto_id, sucursal)
);

-- =========================
-- TABLA VENTAS
-- =========================
CREATE TABLE ventas (
    venta_id INT PRIMARY KEY,
    fecha DATE,
    sucursal VARCHAR(50),
    canal VARCHAR(50),
    producto_id INT,
    cantidad INT,
    precio_unitario DECIMAL(10,2),
    cliente_id INT,
    FOREIGN KEY (cliente_id) REFERENCES clientes(cliente_id)
);

-- =========================
-- LOAD DATA (modificar ruta)
-- =========================

-- CLIENTES
LOAD DATA INFILE 'C:/csv-retail/clientes.csv'
INTO TABLE clientes
FIELDS TERMINATED BY ','
ENCLOSED BY '"'
LINES TERMINATED BY '\n'
IGNORE 1 ROWS;

-- STOCK
LOAD DATA INFILE 'C:/csv-retail/stock.csv'
INTO TABLE stock
FIELDS TERMINATED BY ','
ENCLOSED BY '"'
LINES TERMINATED BY '\n'
IGNORE 1 ROWS;

-- VENTAS
LOAD DATA INFILE 'C:/csv-retail/ventas.csv'
INTO TABLE ventas
FIELDS TERMINATED BY ','
ENCLOSED BY '"'
LINES TERMINATED BY '\n'
IGNORE 1 ROWS;

